#define WIN32_LEAN_AND_MEAN 
#include <Windows.h> 
#include <string> 

std::string sWindowClass = "KlasaOkna"; 

enum BUTTON_ID { ID_BUTTON_WITAJ, ID_BUTTON_ZAMKNIJ };

//przycisk
HWND hButtonWitaj, hButtonZamknij;

HINSTANCE FindInstance(const char* windowClassName)
{
	HWND hWnd=FindWindow(NULL,windowClassName);
	return (HINSTANCE)GetWindowLong(hWnd,GWL_HINSTANCE);
}

HWND ButtonFactory(const char* windowClassName,const char* caption,HWND hWnd,BUTTON_ID button_id,int x,int y)
{
	HINSTANCE hInstance=FindInstance("KlasaOkna");
	return CreateWindowEx(
		NULL,
		windowClassName,
		caption,		
		WS_CHILD | WS_VISIBLE,
		x, y, 200, 70, //geometria
		hWnd,
		(HMENU)button_id,
		hInstance,
		NULL);
}
  
LRESULT CALLBACK WindowEventProc(HWND hWindow, UINT uMsg, WPARAM wParam, LPARAM lParam)
{ 
    switch(uMsg) 
    { 
    case WM_DESTROY: 
        PostQuitMessage(0); 
        break; 

	//przycisk
	case WM_CREATE:
		hButtonWitaj=ButtonFactory("Button","Witaj wiecie!",hWindow,ID_BUTTON_WITAJ,30,30);
		hButtonZamknij=ButtonFactory("Button","Zamknij",hWindow,ID_BUTTON_ZAMKNIJ,240,30);
		break;

	//obsluga przycisku
	case WM_COMMAND:
		switch(wParam)
		{
		case ID_BUTTON_WITAJ:
			MessageBox(NULL,"Witaj wiecie!","Witaj",NULL);
			break;
		case ID_BUTTON_ZAMKNIJ:
			//DestroyWindow(hWnd);
			PostMessage(hWindow,WM_CLOSE,0,0);
			break;
		}
    } 
  
    return DefWindowProc(hWindow, uMsg, wParam, lParam); 
} 

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE, LPSTR, int nCmdShow) 
{ 
	//przycisk
	//ghInstance = &hInstance;

    WNDCLASSEX windowClass; 

    ZeroMemory(&windowClass, sizeof(windowClass)); 
    windowClass.cbSize = sizeof(windowClass); 
    windowClass.hInstance = hInstance; 
    windowClass.lpfnWndProc = WindowEventProc; 
    windowClass.lpszClassName = sWindowClass.c_str(); 
    windowClass.hCursor = LoadCursor(NULL, IDC_ARROW); 
    windowClass.hIcon = LoadIcon(NULL, IDI_APPLICATION); 
    windowClass.hbrBackground = (HBRUSH) COLOR_WINDOW; 
  
    RegisterClassEx(&windowClass); 
      
    HWND hWindow = CreateWindowEx( 
        NULL,                    // window style 
        sWindowClass.c_str(),    // class name 
        "Nazwa okna",            // caption 
        WS_OVERLAPPEDWINDOW,    // window style 
        CW_USEDEFAULT,            // X coord 
        CW_USEDEFAULT,            // Y coord 
        CW_USEDEFAULT,            // width 
        CW_USEDEFAULT,            // height 
        NULL,                    // parent window 
        NULL,                    // menu 
        hInstance,                // app instance 
        NULL                    // additional data 
    ); 
  
    //Pokazywanie okna
    ShowWindow(hWindow, nCmdShow); 
  
    //Petla komunukatow  
    MSG msgMessage; 
    while(GetMessage(&msgMessage, NULL, 0, 0)) 
    { 
        TranslateMessage(&msgMessage); 
        DispatchMessage(&msgMessage); 
    } 
  
    // return code 
    return static_cast<int>(msgMessage.wParam); 
} 

